;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PRS8_1.asm
;;   Version: 3.3, Updated on 2006/05/15 at 15:08:39
;;  Generated by PSoC Designer ver 4.3  b1884 : 23 June, 2006
;;
;;  DESCRIPTION: PRS8 User Module software implementation file
;;               for the 22/24/25/26/27xxx PSoC family of devices.
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"
include "PRS8_1.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export   PRS8_1_Start
export  _PRS8_1_Start
export   PRS8_1_Stop
export  _PRS8_1_Stop
export   PRS8_1_WriteSeed
export  _PRS8_1_WriteSeed
export   PRS8_1_WritePolynomial
export  _PRS8_1_WritePolynomial
export   PRS8_1_bReadPRS
export  _PRS8_1_bReadPRS

;--------------------------------------------
;       WARNING WARNING WARNING
; The following exports are for backwards
; compatibility only and should not be used
; for new designs.
export  bPRS8_1_ReadPRS
export _bPRS8_1_ReadPRS
;--------------------------------------------

;-----------------------------------------------
;  Constant Definitions
;-----------------------------------------------
bfCONTROL_REG_START_BIT:   equ   1        ; Control register start bit


AREA UserModules (ROM, REL)

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: PRS8_1_Start
;
;  DESCRIPTION:
;     Starts the PRS user module.  The PRS will begin computing the psuedo
;     random number sequence on subsequent clocks.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: None
;
;  RETURNS:   None
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
;
 PRS8_1_Start:
_PRS8_1_Start:
   RAM_PROLOGUE RAM_USE_CLASS_1
   or    REG[PRS8_1_CONTROL_REG], bfCONTROL_REG_START_BIT
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: PRS8_1_Stop
;
;  DESCRIPTION:
;     Disables PRS operation.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: None
;
;  RETURNS:   None
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
;    Writing to the Seed register will cause the seed value to be latched into
;    the Shift register.
;
 PRS8_1_Stop:
_PRS8_1_Stop:
   RAM_PROLOGUE RAM_USE_CLASS_1
   and   REG[PRS8_1_CONTROL_REG], ~bfCONTROL_REG_START_BIT
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: PRS8_1_WriteSeed
;
;  DESCRIPTION:
;     Initializes the PRS function with a starting seed value.
;     The PRS User module is stopped while the Seed value is updated and
;     upon exit, its previous start state is restored.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;     bSeedValue - the seed value to initialize the polynomial function.
;        Passed in A
;
;  RETURNS:
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
;    PRS user module is stopped while the seed is updated.
;
 PRS8_1_WriteSeed:
_PRS8_1_WriteSeed:
   RAM_PROLOGUE RAM_USE_CLASS_1
   ;save the input parameter
   push  A

   ;get and save the current start state
   mov   A, REG[PRS8_1_CONTROL_REG]
   mov   X, A

   ;stop the PRS
   and   REG[PRS8_1_CONTROL_REG], ~bfCONTROL_REG_START_BIT

   ; Load the Seed value into the Seed register
   pop   A
   mov   reg[PRS8_1_SEED_REG], A

   ; restore the start state
   mov   A, X
   mov   REG[PRS8_1_CONTROL_REG], A

   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: PRS8_1_WritePolynomial
;
;  DESCRIPTION:
;     Initializes the PRS polynomial value.
;     The PRS User module is stopped while the polynomial value is updated and
;     upon exit, its previous start state is restored.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;     bPolynomial - the polynomial to load into the polynomial register
;        Passed in A
;
;  RETURNS: None
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
;    PRS user module is stopped while the polynomial is updated.
;
 PRS8_1_WritePolynomial:
_PRS8_1_WritePolynomial:
   
   RAM_PROLOGUE RAM_USE_CLASS_1
   ;save the input parameters
   push  A

   ;get and save the current start state
   mov   A, REG[PRS8_1_CONTROL_REG]
   mov   X, A

   ;stop the PRS
   and   REG[PRS8_1_CONTROL_REG], ~bfCONTROL_REG_START_BIT

   ; Load the polynomial into Polynomial register
   pop   A
   mov   reg[PRS8_1_POLY_REG], A

   ; restore the start state
   mov   A, X
   mov   REG[PRS8_1_CONTROL_REG], A

   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: PRS8_1_bReadPRS
;
;  DESCRIPTION:
;     Reads the currently computed PRS function value.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: None
;
;  RETURNS:
;     bPRSValue - PRS value read.
;        Returned in A
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
;    The seed value is lost.
;
;  THEORY of OPERATION or PROCEDURE:
;     1) Read the Shift register - PRS value is transferred to Seed register
;     2) Read the Seed register.
;
 PRS8_1_bReadPRS:
_PRS8_1_bReadPRS:
 bPRS8_1_ReadPRS:    ; For backwards compatibility, do not use!
_bPRS8_1_ReadPRS:    ; For backwards compatibility, do not use!

   RAM_PROLOGUE RAM_USE_CLASS_1
   ; Read the Shift register.  This causes the current
   ;  PRS computed number to be transferred to the Seed register.
   mov   A, reg[PRS8_1_SHIFT_REG]

   ; Read the PRS computed value
   mov   A, reg[PRS8_1_SEED_REG]

   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

; End of File PRS8_1.asm
